<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
// use Illuminate\Support\Facades\Route;
use App\Mail\SendMail;
use App\Mail\SendMessageToEndUser;
use Mail;


class MailController extends Controller
{
    public function send(Request $request)
    {
        $name = $request->name;
        $subject = "Új kapcsolat";
        $email = $request->email;
        $message = $request->message;
        $phone = $request->phone;
        $mailData = [
        'url' =>  config('app.url'),
        ];
        // $send_mail = "info@domakaputech.hu";
        $send_mail = "info@domakaputech.hu";
        try {
            Mail::to($send_mail)->send(new SendMail($name, $email, $phone, $subject, $message));
        } catch (\Throwable $th) {
            return redirect()->back()->with('error', 'Az üzenetet nem sikerült elküldenünk. Kérjük próbálja újra később!');
        }


        $senderMessage = "Köszönjük az üzenetét, hamarosan felvesszük Önnel a kapcsolatot.";

        try {
            Mail::to( $email)->send(new SendMessageToEndUser($name,$senderMessage,$mailData));
        } catch (\Throwable $th) {
            return redirect()->back()->with('error', 'Az üzenetet nem sikerült elküldenünk. Kérjük próbálja újra később!');
        }

        // return "Mail Send Successfully";

        return redirect()->back()->with('success', 'Az üzenetet sikeresen elküldtük! Hamarosan felvesszük Önnel a kapcsolatot.');
    }
}
