<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Http\Requests\GardenGateRequest;
use Illuminate\Support\Facades\Mail;
use App\Mail\GardenGateRequestMail;
use App\Mail\SendMessageToEndUser;

class gardenGateFormController extends Controller
{
    public function showForm()
    {
        return view('kertkapu');
    }

    public function submitForm(GardenGateRequest $request)
    {
        // Az érvényesített adatok:
        $data = $request->validated();
        
        // levél küldés

        // Send to admin
        Mail::to('info@domakaputech.hu')->send(new GardenGateRequestMail($data));

        $name = $request->name;
        $senderMessage = "Köszönjük az üzenetét, hamarosan felvesszük Önnel a kapcsolatot.";
        $email = $request->email;
        $mailData = [
            'url' =>  config('app.url'),
        ];
        
        try {
            Mail::to($email)->send(new SendMessageToEndUser($name, $senderMessage, $mailData));
        } catch (\Throwable $th) {
            return redirect()->back()->with('error', 'Az üzenetet nem sikerült elküldenünk. Kérjük próbálja újra később!');
        }

        return back()->with('success', 'Köszönjük az üzenetét, hamarosan felvesszük Önnel a kapcsolatot.!');
    }
}
