<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Mail;
use App\Mail\PergolaRequestMail;
use App\Mail\SendMessageToEndUser;



class pergolaFormController extends Controller
{
    public function showForm()
    {
        return view('pergola');
    }

    public function submitForm(Request $request)
    {
        //dd($request);
        // 1) Merge defaults: biztosítjuk, hogy radio/checkbox mezők mindig legyenek jelen
        $request->merge([
            'pergolaType' => $request->input('pergolaType', '0'),
            'pergolaCover' => $request->input('pergolaCover', '0'),
            'policarbonatType' => $request->input('policarbonatType', '0'),
            'glassType' => $request->input('glassType', '0'),

            // 'colorBioklimatikusLamella' => $request->input('colorBioklimatikusLamella', '0'),
            // 'colorBioklimatikusStructure' => $request->input('colorBioklimatikusStructure', '0'),

            // checkboxok: ha nincs benne a request-ben, legyen 0

            'extraBioklimatikusZIP' => $request->has('extraBioklimatikusZIP') ? '1' : '0',
            'extraBioklimatikusSlidingGlass' => $request->has('extraBioklimatikusSlidingGlass') ? '1' : '0',
            'extraBioklimatikusZsaluzia' => $request->has('extraBioklimatikusZsaluzia') ? '1' : '0',
            'extraBioklimatikusLEDOptions' => $request->has('extraBioklimatikusLEDOptions') ? '1' : '0',
            'extraPoliGlassZIP' => $request->has('extraPoliGlassZIP') ? '1' : '0',
            'extraPoliGlassSlidingGlass' => $request->has('extraPoliGlassSlidingGlass') ? '1' : '0',
            'installation' => $request->has('installation') ? '1' : '0',
            // további checkboxok hasonlóan...
        ]);

        // 2) Alap szabályok (nem feltételesek)
        $rules = [
            'pergolaType' => 'bail|required|in:1,2',
            'pergolaCover' => 'bail|required|in:1,2,3',

            // méretek
            'sizeOverHang' => 'bail|required|numeric|min:1',
            'sizeLenght' => 'bail|required|numeric|min:1',
            'sizeHeight' => 'bail|required|numeric|min:1',

            // alap validáció a szöveges kapcsolattartó mezőkre
            'name' => 'bail|required|string|max:100',
            'email' => 'bail|required|email|max:100',
            'phone' => 'bail|required|string|max:30',

            // text mezők, alapban nem required (feltételesen tesszük requireddé)
            'colorBioklimatikusLamellaText' => 'nullable|string|max:100',
            'colorBioklimatikusStructureText' => 'nullable|string|max:100',
            'colorPolicarbonatStructureText' => 'nullable|string|max:100',
            'installationPlace' => 'nullable|string|max:255',

            // Checkbox mezők (mind opcionális, de validált)
            'extraBioklimatikusZIP' => 'in:0,1',
            'extraBioklimatikusSlidingGlass' => 'in:0,1',
            'extraBioklimatikusZsaluzia' => 'in:0,1',
            'extraBioklimatikusRainSensor' => 'in:0,1',
            'extraBioklimatikusWindSensor' => 'in:0,1',
            'extraBioklimatikusLEDOptions' => 'in:0,1',
            'extraPoliGlassZIP' => 'in:0,1',
            'extraPoliGlassSlidingGlass' => 'in:0,1',
            'extraPoliGlassLEDSpot' => 'in:0,1',
            'installation' => 'in:0,1',
        ];

        // 3) Létrehozzuk a validátort
        $validator = Validator::make($request->all(), $rules);

        // 4) Feltételes szabályok with sometimes
        $validator->sometimes('policarbonatType', 'required|in:1,2', function ($input) {
            return isset($input->pergolaCover) && (string)$input->pergolaCover === '2';
        });

        $validator->sometimes('glassType', 'required|in:1,2,3', function ($input) {
            return isset($input->pergolaCover) && (string)$input->pergolaCover === '3';
        });

        $validator->sometimes('colorBioklimatikusLamella', 'required|in:1,2,3,4,5,6', function ($input) {
            return isset($input->pergolaCover) && (string)$input->pergolaCover === '1';
        });

        $validator->sometimes('colorBioklimatikusStructure', 'required|in:1,2,3,4,5,6', function ($input) {
            return isset($input->pergolaCover) && (string)$input->pergolaCover === '1';
        });

        $validator->sometimes('colorPolicarbonatStructure', 'required|in:1,2,3,4,5', function ($input) {
            return isset($input->pergolaCover) && (string)$input->pergolaCover === '2';
        });

        $validator->sometimes('colorGlassStructure', 'required|in:1,2', function ($input) {
            return isset($input->pergolaCover) && (string)$input->pergolaCover === '3';
        });

        // LED választás csak ha opció be van kapcsolva
        $validator->sometimes('extraBioklimatikusLED', 'required|in:1,2,3', function ($input) {
            return isset($input->extraBioklimatikusLEDOptions) && (string)$input->extraBioklimatikusLEDOptions === '1';
        });

        // Egyedi "más szín" mezők required, ha az adott radio a "Más szín" értékre van állítva
        $validator->sometimes('colorBioklimatikusLamellaText', 'required|string|max:100', function ($input) {
            return isset($input->colorBioklimatikusLamella) && (string)$input->colorBioklimatikusLamella === '6';
        });

        $validator->sometimes('colorBioklimatikusStructureText', 'required|string|max:100', function ($input) {
            return isset($input->colorBioklimatikusStructure) && (string)$input->colorBioklimatikusStructure === '6';
        });

        $validator->sometimes('colorPolicarbonatStructureText', 'required|string|max:100', function ($input) {
            return isset($input->colorPolicarbonatStructure) && (string)$input->colorPolicarbonatStructure === '5';
        });

        // Feltételes numerikus mezők: Zip / Tolóüveg / Zsaluzia
        $validator->sometimes('extraBioklimatikusZIPShort', 'required|numeric|min:0', function ($input) {
            return isset($input->extraBioklimatikusZIP) && (string)$input->extraBioklimatikusZIP === '1';
        });
        $validator->sometimes('extraBioklimatikusZIPLong', 'required|numeric|min:0', function ($input) {
            return isset($input->extraBioklimatikusZIP) && (string)$input->extraBioklimatikusZIP === '1';
        });

        $validator->sometimes('extraBioklimatikusSlidingGlassShort', 'required|numeric|min:0', function ($input) {
            return isset($input->extraBioklimatikusSlidingGlass) && (string)$input->extraBioklimatikusSlidingGlass === '1';
        });
        $validator->sometimes('extraBioklimatikusSlidingGlassLong', 'required|numeric|min:0', function ($input) {
            return isset($input->extraBioklimatikusSlidingGlass) && (string)$input->extraBioklimatikusSlidingGlass === '1';
        });

        $validator->sometimes('extraBioklimatikusZsaluziaShort', 'required|numeric|min:0', function ($input) {
            return isset($input->extraBioklimatikusZsaluzia) && (string)$input->extraBioklimatikusZsaluzia === '1';
        });
        $validator->sometimes('extraBioklimatikusZsaluziaLong', 'required|numeric|min:0', function ($input) {
            return isset($input->extraBioklimatikusZsaluzia) && (string)$input->extraBioklimatikusZsaluzia === '1';
        });

        $validator->sometimes('extraPoliGlassZIPShort', 'required|numeric|min:0', function ($input) {
            return isset($input->extraPoliGlassZIP) && (string)$input->extraPoliGlassZIP === '1';
        });
        $validator->sometimes('extraPoliGlassZIPLong', 'required|numeric|min:0', function ($input) {
            return isset($input->extraPoliGlassZIP) && (string)$input->extraPoliGlassZIP === '1';
        });

        $validator->sometimes('extraPoliGlassSlidingGlassShort', 'required|numeric|min:0', function ($input) {
            return isset($input->extraPoliGlassSlidingGlass) && (string)$input->extraPoliGlassSlidingGlass === '1';
        });
        $validator->sometimes('extraPoliGlassSlidingGlassLong', 'required|numeric|min:0', function ($input) {
            return isset($input->extraPoliGlassSlidingGlass) && (string)$input->extraPoliGlassSlidingGlass === '1';
        });

        // InstallationPlace csak ha installation be van pipálva
        $validator->sometimes('installationPlace', 'required|string|max:255', function ($input) {
            return isset($input->installation) && (string)$input->installation === '1';
        });

        // 5) Futtatjuk a validációt és kezeljük a hibákat
        if ($validator->fails()) {
            // debug: dd($validator->errors()->toArray());
            return back()->withErrors($validator)->withInput();
        }

        // 6) Ha minden ok, dolgozd fel a request-et
        // például: Model::create(...), email küldés, stb.
        // levél küldés
        $data = $validator->validated();

        // Send to admin
        Mail::to('info@domakaputech.hu')->send(new PergolaRequestMail($data));

        $name = $request->name;
        $senderMessage = "Köszönjük az üzenetét, hamarosan felvesszük Önnel a kapcsolatot.";
        $email = $request->email;
        $mailData = [
            'url' =>  config('app.url'),
        ];

        try {
            Mail::to($email)->send(new SendMessageToEndUser($name, $senderMessage, $mailData));
        } catch (\Throwable $th) {
            return redirect()->back()->with('error', 'Az üzenetet nem sikerült elküldenünk. Kérjük próbálja újra később!');
        }

        return back()->with('success', 'Köszönjük az üzenetét, hamarosan felvesszük Önnel a kapcsolatot.!');
    }
}
