@extends('layouts.app')
@section('title', 'PERGOLÁK ÉS TERASZFEDÉSEK - DOMA Gate Kft.')
@section('meta_description', 'Prémium bioklimatikus pergolák, napellenzők és teraszfedések. Modern árnyékolástechnika motoros vezérléssel, egyedi kivitelben – DOMA Gate Kft.')
@section('meta_keywords', 'pergola, bioklimatikus pergola, árnyékolás, napellenző, teraszfedés, motoros pergola, kültéri árnyékolás, pergola Veszprém, prémium árnyékolástechnika')
@section('content')

<!-- Masthead-->
<header class="masthead masthead_bg_pergola">
    <div class="container px-4 px-lg-5 d-flex h-100 align-items-center justify-content-start">
        <div class="d-flex justify-content-center">
            <div class="text-start">
                <h1 class="mx-auto my-0 text-uppercase mb-3">DOMA GATE KFT – PERGOLÁK ÉS TERASZFEDÉSEK</h1>
                <h2 class="text-white-50 mt-2 mb-2">Büszkék vagyunk, hogy cégünk, a Doma Gate Kft. a minőségi pergolák és árnyékolástechnikai megoldások szakértője, valamint hivatalos Umbroll viszonteladó.</h2>
                <h2 class="text-white-50 mt-2 mb-2">Kínálatunkban elérhetők saját márkás bioklimatikus, PVC tetős és elhúzható lamellás, valamint Umbroll bioklimatikus, üveg- és polikarbonát fedésű pergolák.</h2>
                <h2 class="text-white-50 mt-2 mb-5">Modern design, időjárásálló kivitel és személyre szabott megoldások jellemzik rendszereinket, hogy pergolája tökéletesen illeszkedjen otthonához.</h2>
                <a class="btn btn-primary" href="#ajanlat">Ajánlatkérés</a>
            </div>
        </div>
    </div>
</header>
<!-- Features-->
<section class="about-section text-center" id="about">
    <div class="container px-4 px-lg-5">
        <div class="row gx-4 gx-lg-5 justify-content-center">
            <div class="col-lg-8">
                <h2 class="text-white mb-4">Bioklimatikus, elhúzható PVC tetős és üveg/polikarbonát fedéses pergolák – Prémium árnyékolás otthonra és üzleti célra</h2>
                <p class="text-white-50 mb-3">
                    Szeretnél modern, elegáns és időtálló teraszfedést? A bioklimatikus pergola ideális választás teraszra, kertbe, autóbeállóhoz vagy vendéglátóhelyre.
                </p>
                <p class="text-white-50 mb-3">
                    Kínálatunkban megtalálod a Doma Gate saját márkás bioklimatikus, elhúzható PVC tetős és elhúzható lamellás pergolákat, valamint az Umbroll prémium bioklimatikus, üveg- és polikarbonát fedésű modelljeit.
                </p>
                <p class="text-white-50 mb-3">
                    Minden pergolánk időtálló, kezelésmentes alumínium szerkezettel készül, így garantált a hosszú élettartam, a megbízható működés és a prémium minőség.
                </p>
            </div>
        </div>
        <img class="img-fluid" src="assets/img/gd-doma-gate-pergola.jpg" alt="..." />
    </div>
</section>
<!-- Descritions-->
<section class="projects-section bg-light" id="kapuleiras">
    <div class="container px-4 px-lg-5">
        <!-- Featured Project Row-->
        <div class="row gx-0 mb-4 mb-lg-5 align-items-center">
            <div class="col-xl-6 col-lg-6">
                <img class="img-fluid mb-3 mb-lg-0" src="{{ asset('assets/img/doma-gate-pergola-016.jpg') }}" alt="..." />
            </div>
            <div class="col-xl-6 col-lg-6">
                <div class=" featured-text text-center text-lg-left">
                    <h2 class="text-start">Saját márkás bioklimatikus pergola</h2>
                    <div class="text-start mt-3">A Doma Gate saját márkás bioklimatikus pergolája ideális választás, ha modern, motoros és lamellás teraszfedést keresel otthonodhoz vagy üzleti környezetbe.</div>
                    <div class="text-start mt-3">Prémium minőségű alumínium szerkezettel, időjárásálló kivitelben, és hosszú élettartamra tervezve.</div>
                    <div class="text-start mt-2">
                        <ul>
                            <li class="mt-1">Alumínium szerkezet: stabil, vastagfalú és karbantartásmentes</li>
                            <li class="mt-1">Lamellás vagy PVC tető: állítható fény- és szellőzés-szabályozás a maximális kényelemért</li>
                            <li class="mt-1">Motoros működtetés: távirányítóval vagy okostelefonos applikációval vezérelhető</li>
                            <li class="mt-1">Gyártási idő: 8–16 hét, kedvező ár-érték arány</li>
                            <li class="mt-1">Garancia: 15 év a pergola szerkezetre</li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
        <div class="row gx-0 mb-4 mb-lg-5 align-items-center flex-column-reverse flex-md-row">
            <div class="col-xl-6 col-lg-6">
                <div class=" featured-text text-center text-lg-left">
                    <h2 class="text-start">Umbroll bioklimatikus pergola</h2>
                    <div class="text-start mt-3">Az Umbroll bioklimatikus pergola a prémium kategóriát képviseli a lamellás árnyékolók között.</div>
                    <div class="text-start mt-2">
                        <ul>
                            <li class="mt-1">Porfestett alumínium szerkezet: korrózióálló és rendkívül tartós</li>
                            <li class="mt-1">Okos extrák: eső- és szélérzékelő, LED világítás, zip screen oldalfalak, üveg tolófalak, okosotthon rendszer</li>
                            <li class="mt-1">Letisztult design: elegancia és modern megjelenés</li>
                            <li class="mt-1">Több éves magyarországi háttér és gyors gyártási idő</li>
                        </ul>
                    </div>
                </div>
            </div>
            <div class="col-xl-6 col-lg-6">
                <img class="img-fluid mb-3 mb-lg-0" src="{{ asset('assets/img/doma-gate-pergola-012.jpg') }}" alt="..." />
            </div>
        </div>
        <div class="row gx-0 mb-4 mb-lg-5 align-items-center">
            <div class="col-xl-6 col-lg-6">
                <img class="img-fluid mb-3 mb-lg-0" src="{{ asset('assets/img/doma-gate-pergola-032.jpg') }}" alt="..." />
            </div>
            <div class="col-xl-6 col-lg-6">
                <div class=" featured-text text-center text-lg-left">
                    <h2 class="text-start">Polikarbonát pergola</h2>
                    <div class="text-start mt-3">A polikarbonát tetős pergola a praktikus és költséghatékony árnyékolási megoldás, minden esetben alumínium vázzal készítve.</div>
                    <div class="text-start mt-2">
                        <ul>
                            <li class="mt-1">Alumínium szerkezet: stabil és hosszú élettartamú</li>
                            <li class="mt-1">Polikarbonát tető UV-védelemmel: fényáteresztő, eső- és hóálló</li>
                            <li class="mt-1">Könnyű, mégis strapabíró anyag</li>
                            <li class="mt-1">Gazdaságos ár, gyors telepítés</li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
        <div class="row gx-0 mb-4 mb-lg-5 align-items-center flex-column-reverse flex-md-row">
            <div class="col-xl-6 col-lg-6">
                <div class=" featured-text text-center text-lg-left">
                    <h2 class="text-start">Üveg fedéses pergola</h2>
                    <div class="text-start mt-3">Az üvegtetős pergola egy exkluzív fixtetős választás, masszív alumínium szerkezettel és prémium üvegfedéssel.</div>
                    <div class="text-start mt-2">
                        <ul>
                            <li class="mt-1">Alumínium váz: erős és időjárásálló</li>
                            <li class="mt-1">Biztonsági üveg tető: modern és elegáns árnyékolás</li>
                            <li class="mt-1">Teljes fényáteresztés, letisztult dizájn</li>
                            <li class="mt-1">Rendkívül tartós, prémium megjelenés</li>
                        </ul>
                    </div>
                </div>
            </div>
            <div class="col-xl-6 col-lg-6">
                <img class="img-fluid mb-3 mb-lg-0" src="{{ asset('assets/img/doma-gate-pergola-056.jpg') }}" alt="..." />
            </div>
        </div>
    </div>
</section>
{{-- Installation START --}}
<section id="beszereles" class="text-white">
    <div class="container px-4 px-lg-5">
        <h2 class="text-center mb-5">Miért érdemes a Doma Gate Kft.-t választani?</h2>
        <div class="row mb-2">
            <div class="col-md-8 offset-md-2">
                <div class="card">
                    <ul class="mt-3 list-unstyled">
                        <li class="mt-2 text-white font-weight-bold">&#10004; Teljes körű szolgáltatás – helyszíni felmérés, pergola-tervezés és kivitelezés egy kézből</li>
                        <li class="mt-2 text-white font-weight-bold">&#10004; Időtálló, vastagfalú alumínium pergolák – karbantartásmentes kivitel, hosszú távra tervezve.</li>
                        <li class="mt-2 text-white font-weight-bold">&#10004; Széles választék – saját márkás és Umbroll prémium pergolák</li>
                        <li class="mt-2 text-white font-weight-bold">&#10004; Valós referenciák – nézd meg korábbi pergoláinkat galériánkban és Facebook-oldalunkon</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</section>
{{-- Installation END --}}
{{-- Gallery START --}}
<section id="galeria" class="bg-light">
    <div class="container px-4 px-lg-5">
        <h2 class="text-center mb-5">Galéria</h2>
        <svg class="d-none" xmlns="http://www.w3.org/2000/svg">
            <symbol id="enlarge" viewBox="0 0 16 16">
                <path d="M1.5 1a.5.5 0 0 0-.5.5v4a.5.5 0 0 1-1 0v-4A1.5 1.5 0 0 1 1.5 0h4a.5.5 0 0 1 0 1h-4zM10 .5a.5.5 0 0 1 .5-.5h4A1.5 1.5 0 0 1 16 1.5v4a.5.5 0 0 1-1 0v-4a.5.5 0 0 0-.5-.5h-4a.5.5 0 0 1-.5-.5zM.5 10a.5.5 0 0 1 .5.5v4a.5.5 0 0 0 .5.5h4a.5.5 0 0 1 0 1h-4A1.5 1.5 0 0 1 0 14.5v-4a.5.5 0 0 1 .5-.5zm15 0a.5.5 0 0 1 .5.5v4a1.5 1.5 0 0 1-1.5 1.5h-4a.5.5 0 0 1 0-1h4a.5.5 0 0 0 .5-.5v-4a.5.5 0 0 1 .5-.5z" />
            </symbol>
            <symbol id="exit" viewBox="0 0 16 16">
                <path d="M5.5 0a.5.5 0 0 1 .5.5v4A1.5 1.5 0 0 1 4.5 6h-4a.5.5 0 0 1 0-1h4a.5.5 0 0 0 .5-.5v-4a.5.5 0 0 1 .5-.5zm5 0a.5.5 0 0 1 .5.5v4a.5.5 0 0 0 .5.5h4a.5.5 0 0 1 0 1h-4A1.5 1.5 0 0 1 10 4.5v-4a.5.5 0 0 1 .5-.5zM0 10.5a.5.5 0 0 1 .5-.5h4A1.5 1.5 0 0 1 6 11.5v4a.5.5 0 0 1-1 0v-4a.5.5 0 0 0-.5-.5h-4a.5.5 0 0 1-.5-.5zm10 1a1.5 1.5 0 0 1 1.5-1.5h4a.5.5 0 0 1 0 1h-4a.5.5 0 0 0-.5.5v4a.5.5 0 0 1-1 0v-4z" />
            </symbol>
        </svg>

        <section class="photo-gallery">
            <div class="container">
                <div class="row row-cols-1 row-cols-md-2 row-cols-lg-3 g-4 gallery-grid">
                    <div class="col">
                        <a class="gallery-item" href="{{ asset('assets/img/doma-gate-pergola-001.jpg') }}">
                            <img src="{{ asset('assets/img/doma-gate-pergola-001.jpg') }}" class="img-fluid" alt="">
                        </a>
                    </div>
                    <div class="col">
                        <a class="gallery-item" href="{{ asset('assets/img/doma-gate-pergola-002.jpg') }}">
                            <img src="{{ asset('assets/img/doma-gate-pergola-002.jpg') }}" class="img-fluid" alt="">
                        </a>
                    </div>
                    <div class="col">
                        <a class="gallery-item" href="{{ asset('assets/img/doma-gate-pergola-003.jpg') }}">
                            <img src="{{ asset('assets/img/doma-gate-pergola-003.jpg') }}" class="img-fluid" alt="">
                        </a>
                    </div>
                    <div class="col">
                        <a class="gallery-item" href="{{ asset('assets/img/doma-gate-pergola-004.jpg') }}">
                            <img src="{{ asset('assets/img/doma-gate-pergola-004.jpg') }}" class="img-fluid" alt="">
                        </a>
                    </div>
                    <div class="col">
                        <a class="gallery-item" href="{{ asset('assets/img/doma-gate-pergola-005.jpg') }}">
                            <img src="{{ asset('assets/img/doma-gate-pergola-005.jpg') }}" class="img-fluid" alt="">
                        </a>
                    </div>
                    <div class="col">
                        <a class="gallery-item" href="{{ asset('assets/img/doma-gate-pergola-006.jpg') }}">
                            <img src="{{ asset('assets/img/doma-gate-pergola-006.jpg') }}" class="img-fluid" alt="">
                        </a>
                    </div>
                    <div class="col">
                        <a class="gallery-item" href="{{ asset('assets/img/doma-gate-pergola-007.jpg') }}">
                            <img src="{{ asset('assets/img/doma-gate-pergola-007.jpg') }}" class="img-fluid" alt="">
                        </a>
                    </div>
                    <div class="col">
                        <a class="gallery-item" href="{{ asset('assets/img/doma-gate-pergola-008.jpg') }}">
                            <img src="{{ asset('assets/img/doma-gate-pergola-008.jpg') }}" class="img-fluid" alt="">
                        </a>
                    </div>
                    <div class="col">
                        <a class="gallery-item" href="{{ asset('assets/img/doma-gate-pergola-009.jpg') }}">
                            <img src="{{ asset('assets/img/doma-gate-pergola-009.jpg') }}" class="img-fluid" alt="">
                        </a>
                    </div>
                    <div class="col">
                        <a class="gallery-item" href="{{ asset('assets/img/doma-gate-pergola-010.jpg') }}">
                            <img src="{{ asset('assets/img/doma-gate-pergola-010.jpg') }}" class="img-fluid" alt="">
                        </a>
                    </div>
                    <div class="col">
                        <a class="gallery-item" href="{{ asset('assets/img/doma-gate-pergola-011.jpg') }}">
                            <img src="{{ asset('assets/img/doma-gate-pergola-011.jpg') }}" class="img-fluid" alt="">
                        </a>
                    </div>
                    <div class="col">
                        <a class="gallery-item" href="{{ asset('assets/img/doma-gate-pergola-012.jpg') }}">
                            <img src="{{ asset('assets/img/doma-gate-pergola-012.jpg') }}" class="img-fluid" alt="">
                        </a>
                    </div>
                    <div class="col">
                        <a class="gallery-item" href="{{ asset('assets/img/doma-gate-pergola-013.jpg') }}">
                            <img src="{{ asset('assets/img/doma-gate-pergola-013.jpg') }}" class="img-fluid" alt="">
                        </a>
                    </div>
                    <div class="col">
                        <a class="gallery-item" href="{{ asset('assets/img/doma-gate-pergola-014.jpg') }}">
                            <img src="{{ asset('assets/img/doma-gate-pergola-014.jpg') }}" class="img-fluid" alt="">
                        </a>
                    </div>
                    <div class="col">
                        <a class="gallery-item" href="{{ asset('assets/img/doma-gate-pergola-015.jpg') }}">
                            <img src="{{ asset('assets/img/doma-gate-pergola-015.jpg') }}" class="img-fluid" alt="">
                        </a>
                    </div>
                    <div class="col">
                        <a class="gallery-item" href="{{ asset('assets/img/doma-gate-pergola-016.jpg') }}">
                            <img src="{{ asset('assets/img/doma-gate-pergola-016.jpg') }}" class="img-fluid" alt="">
                        </a>
                    </div>
                    <div class="col">
                        <a class="gallery-item" href="{{ asset('assets/img/doma-gate-pergola-017.jpg') }}">
                            <img src="{{ asset('assets/img/doma-gate-pergola-017.jpg') }}" class="img-fluid" alt="">
                        </a>
                    </div>
                    <div class="col">
                        <a class="gallery-item" href="{{ asset('assets/img/doma-gate-pergola-018.jpg') }}">
                            <img src="{{ asset('assets/img/doma-gate-pergola-018.jpg') }}" class="img-fluid" alt="">
                        </a>
                    </div>
                    <div class="col">
                        <a class="gallery-item" href="{{ asset('assets/img/doma-gate-pergola-019.jpg') }}">
                            <img src="{{ asset('assets/img/doma-gate-pergola-019.jpg') }}" class="img-fluid" alt="">
                        </a>
                    </div>
                    <div class="col">
                        <a class="gallery-item" href="{{ asset('assets/img/doma-gate-pergola-020.jpg') }}">
                            <img src="{{ asset('assets/img/doma-gate-pergola-020.jpg') }}" class="img-fluid" alt="">
                        </a>
                    </div>
                    <div class="col">
                        <a class="gallery-item" href="{{ asset('assets/img/doma-gate-pergola-021.jpg') }}">
                            <img src="{{ asset('assets/img/doma-gate-pergola-021.jpg') }}" class="img-fluid" alt="">
                        </a>
                    </div>
                    <div class="col">
                        <a class="gallery-item" href="{{ asset('assets/img/doma-gate-pergola-022.jpg') }}">
                            <img src="{{ asset('assets/img/doma-gate-pergola-022.jpg') }}" class="img-fluid" alt="">
                        </a>
                    </div>
                    <div class="col">
                        <a class="gallery-item" href="{{ asset('assets/img/doma-gate-pergola-023.jpg') }}">
                            <img src="{{ asset('assets/img/doma-gate-pergola-023.jpg') }}" class="img-fluid" alt="">
                        </a>
                    </div>
                    <div class="col">
                        <a class="gallery-item" href="{{ asset('assets/img/doma-gate-pergola-024.jpg') }}">
                            <img src="{{ asset('assets/img/doma-gate-pergola-024.jpg') }}" class="img-fluid" alt="">
                        </a>
                    </div>
                    <div class="col">
                        <a class="gallery-item" href="{{ asset('assets/img/doma-gate-pergola-025.jpg') }}">
                            <img src="{{ asset('assets/img/doma-gate-pergola-025.jpg') }}" class="img-fluid" alt="">
                        </a>
                    </div>
                    <div class="col">
                        <a class="gallery-item" href="{{ asset('assets/img/doma-gate-pergola-026.jpg') }}">
                            <img src="{{ asset('assets/img/doma-gate-pergola-026.jpg') }}" class="img-fluid" alt="">
                        </a>
                    </div>
                    <div class="col">
                        <a class="gallery-item" href="{{ asset('assets/img/doma-gate-pergola-027.jpg') }}">
                            <img src="{{ asset('assets/img/doma-gate-pergola-027.jpg') }}" class="img-fluid" alt="">
                        </a>
                    </div>
                    <div class="col">
                        <a class="gallery-item" href="{{ asset('assets/img/doma-gate-pergola-028.jpg') }}">
                            <img src="{{ asset('assets/img/doma-gate-pergola-028.jpg') }}" class="img-fluid" alt="">
                        </a>
                    </div>
                    <div class="col">
                        <a class="gallery-item" href="{{ asset('assets/img/doma-gate-pergola-029.jpg') }}">
                            <img src="{{ asset('assets/img/doma-gate-pergola-029.jpg') }}" class="img-fluid" alt="">
                        </a>
                    </div>
                    <div class="col">
                        <a class="gallery-item" href="{{ asset('assets/img/doma-gate-pergola-030.jpg') }}">
                            <img src="{{ asset('assets/img/doma-gate-pergola-030.jpg') }}" class="img-fluid" alt="">
                        </a>
                    </div>
                    <div class="col">
                        <a class="gallery-item" href="{{ asset('assets/img/doma-gate-pergola-031.jpg') }}">
                            <img src="{{ asset('assets/img/doma-gate-pergola-031.jpg') }}" class="img-fluid" alt="">
                        </a>
                    </div>
                    <div class="col">
                        <a class="gallery-item" href="{{ asset('assets/img/doma-gate-pergola-032.jpg') }}">
                            <img src="{{ asset('assets/img/doma-gate-pergola-032.jpg') }}" class="img-fluid" alt="">
                        </a>
                    </div>
                    <div class="col">
                        <a class="gallery-item" href="{{ asset('assets/img/doma-gate-pergola-033.jpg') }}">
                            <img src="{{ asset('assets/img/doma-gate-pergola-033.jpg') }}" class="img-fluid" alt="">
                        </a>
                    </div>
                    <div class="col">
                        <a class="gallery-item" href="{{ asset('assets/img/doma-gate-pergola-034.jpg') }}">
                            <img src="{{ asset('assets/img/doma-gate-pergola-034.jpg') }}" class="img-fluid" alt="">
                        </a>
                    </div>
                    <div class="col">
                        <a class="gallery-item" href="{{ asset('assets/img/doma-gate-pergola-035.jpg') }}">
                            <img src="{{ asset('assets/img/doma-gate-pergola-035.jpg') }}" class="img-fluid" alt="">
                        </a>
                    </div>
                    <div class="col">
                        <a class="gallery-item" href="{{ asset('assets/img/doma-gate-pergola-036.jpg') }}">
                            <img src="{{ asset('assets/img/doma-gate-pergola-036.jpg') }}" class="img-fluid" alt="">
                        </a>
                    </div>
                    <div class="col">
                        <a class="gallery-item" href="{{ asset('assets/img/doma-gate-pergola-038.jpg') }}">
                            <img src="{{ asset('assets/img/doma-gate-pergola-038.jpg') }}" class="img-fluid" alt="">
                        </a>
                    </div>
                    <div class="col">
                        <a class="gallery-item" href="{{ asset('assets/img/doma-gate-pergola-039.jpg') }}">
                            <img src="{{ asset('assets/img/doma-gate-pergola-039.jpg') }}" class="img-fluid" alt="">
                        </a>
                    </div>
                    <div class="col">
                        <a class="gallery-item" href="{{ asset('assets/img/doma-gate-pergola-040.jpg') }}">
                            <img src="{{ asset('assets/img/doma-gate-pergola-040.jpg') }}" class="img-fluid" alt="">
                        </a>
                    </div>
                    <div class="col">
                        <a class="gallery-item" href="{{ asset('assets/img/doma-gate-pergola-041.jpg') }}">
                            <img src="{{ asset('assets/img/doma-gate-pergola-041.jpg') }}" class="img-fluid" alt="">
                        </a>
                    </div>
                    <div class="col">
                        <a class="gallery-item" href="{{ asset('assets/img/doma-gate-pergola-042.jpg') }}">
                            <img src="{{ asset('assets/img/doma-gate-pergola-042.jpg') }}" class="img-fluid" alt="">
                        </a>
                    </div>
                    <div class="col">
                        <a class="gallery-item" href="{{ asset('assets/img/doma-gate-pergola-043.jpg') }}">
                            <img src="{{ asset('assets/img/doma-gate-pergola-043.jpg') }}" class="img-fluid" alt="">
                        </a>
                    </div>
                    <div class="col">
                        <a class="gallery-item" href="{{ asset('assets/img/doma-gate-pergola-044.jpg') }}">
                            <img src="{{ asset('assets/img/doma-gate-pergola-044.jpg') }}" class="img-fluid" alt="">
                        </a>
                    </div>
                    <div class="col">
                        <a class="gallery-item" href="{{ asset('assets/img/doma-gate-pergola-045.jpg') }}">
                            <img src="{{ asset('assets/img/doma-gate-pergola-045.jpg') }}" class="img-fluid" alt="">
                        </a>
                    </div>
                    <div class="col">
                        <a class="gallery-item" href="{{ asset('assets/img/doma-gate-pergola-047.jpg') }}">
                            <img src="{{ asset('assets/img/doma-gate-pergola-047.jpg') }}" class="img-fluid" alt="">
                        </a>
                    </div>
                    <div class="col">
                        <a class="gallery-item" href="{{ asset('assets/img/doma-gate-pergola-048.jpg') }}">
                            <img src="{{ asset('assets/img/doma-gate-pergola-048.jpg') }}" class="img-fluid" alt="">
                        </a>
                    </div>
                    <div class="col">
                        <a class="gallery-item" href="{{ asset('assets/img/doma-gate-pergola-049.jpg') }}">
                            <img src="{{ asset('assets/img/doma-gate-pergola-049.jpg') }}" class="img-fluid" alt="">
                        </a>
                    </div>
                    <div class="col">
                        <a class="gallery-item" href="{{ asset('assets/img/doma-gate-pergola-050.jpg') }}">
                            <img src="{{ asset('assets/img/doma-gate-pergola-050.jpg') }}" class="img-fluid" alt="">
                        </a>
                    </div>
                    <div class="col">
                        <a class="gallery-item" href="{{ asset('assets/img/doma-gate-pergola-051.jpg') }}">
                            <img src="{{ asset('assets/img/doma-gate-pergola-051.jpg') }}" class="img-fluid" alt="">
                        </a>
                    </div>
                    <div class="col">
                        <a class="gallery-item" href="{{ asset('assets/img/doma-gate-pergola-052.jpg') }}">
                            <img src="{{ asset('assets/img/doma-gate-pergola-052.jpg') }}" class="img-fluid" alt="">
                        </a>
                    </div>
                    <div class="col">
                        <a class="gallery-item" href="{{ asset('assets/img/doma-gate-pergola-053.jpg') }}">
                            <img src="{{ asset('assets/img/doma-gate-pergola-053.jpg') }}" class="img-fluid" alt="">
                        </a>
                    </div>
                    <div class="col">
                        <a class="gallery-item" href="{{ asset('assets/img/doma-gate-pergola-054.jpg') }}">
                            <img src="{{ asset('assets/img/doma-gate-pergola-054.jpg') }}" class="img-fluid" alt="">
                        </a>
                    </div>
                    <div class="col">
                        <a class="gallery-item" href="{{ asset('assets/img/doma-gate-pergola-055.jpg') }}">
                            <img src="{{ asset('assets/img/doma-gate-pergola-055.jpg') }}" class="img-fluid" alt="">
                        </a>
                    </div>
                </div>
            </div>
        </section>

        <div class="modal fade lightbox-modal" id="lightbox-modal" tabindex="-1">
            <div class="modal-dialog modal-dialog-centered modal-fullscreen">
                <div class="modal-content">
                    <button type="button" class="btn-fullscreen-enlarge" aria-label="Enlarge fullscreen">
                        <svg class="bi">
                            <use href="#enlarge"></use>
                        </svg>
                    </button>
                    <button type="button" class="btn-fullscreen-exit d-none" aria-label="Exit fullscreen">
                        <svg class="bi">
                            <use href="#exit"></use>
                        </svg>
                    </button>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    <div class="modal-body">
                        <div class="lightbox-content">
                            <!-- JS content here -->
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
{{-- Gallery END --}}
{{-- Contact form --}}
<section class="signup-section" id="ajanlat">
    <div class="container px-4 px-lg-5">
        <div class="row gx-4 gx-lg-5">
            <div class="col-md-10 col-lg-8 mx-auto text-center">
                <i class="far fa-solid fa-pencil fa-2x mb-2 text-white"></i>
                <h2 class="text-white mb-5">Ajánlat kérés pergolára</h2>
                <div class="text-white-50 text-center mb-5">
                    Minden projekt egyedi, ezért személyre szabott árajánlatot készítünk.<br>
                    Vedd fel velünk a kapcsolatot, és 24 órán belül jelentkezünk!
                </div>
                <form class="form-signup" id="contactForm" action="{{ route('pergola.submit') }}" method="POST"
                    enctype="multipart/form-data">
                    @csrf
                    <div class="row input-group-newsletter">
                        <div class="col-12 mb-5 text-start ">
                            <input type="radio" name="pergolaType" value="0" hidden {{ old('pergolaType', '0') == '0' ? 'checked' : '' }}>
                            <div class="form-check form-check-inline">
                                <input class="" type="radio" name="pergolaType" id="pergolaType1" value="1" {{ old('pergolaType', '0') == '1' ? 'checked' : '' }}>
                                <label class="form-check-label text-primary text-start text-white" for="pergolaType1">Falra szerelt</label>
                            </div>

                            <div class="form-check form-check-inline">
                                <input class="" type="radio" name="pergolaType" id="pergolaType2" value="2" {{ old('pergolaType', '0') == '2' ? 'checked' : '' }}>
                                <label class="form-check-label text-primary text-start text-white" for="pergolaType2">Szabadon álló</label>
                            </div>
                            @if ($errors->has('pergolaType'))
                            <span class="text-danger error-message">{{ $errors->first('pergolaType') }}</span>
                            @endif
                        </div>

                        <div class="col-12 mb-5 text-start ">
                            <input type="radio" name="pergolaCover" value="0" hidden {{ old('pergolaCover', '0') == '0' ? 'checked' : '' }}>
                            <div class="form-check form-check-inline">
                                <input class="" type="radio" name="pergolaCover" id="pergolaCover1" value="1" {{ old('pergolaCover', '0') == '1' ? 'checked' : '' }}>
                                <label class="form-check-label text-primary text-start text-white" for="pergolaCover1">Bioklimatikus</label>
                            </div>

                            <div class="form-check form-check-inline">
                                <input class="" type="radio" name="pergolaCover" id="pergolaCover2" value="2" {{ old('pergolaCover', '0') == '2' ? 'checked' : '' }}>
                                <label class="form-check-label text-primary text-start text-white" for="pergolaCover2">Polikarbonát tetős</label>
                            </div>

                            <div class="form-check form-check-inline">
                                <input class="" type="radio" name="pergolaCover" id="pergolaCover3" value="3" {{ old('pergolaCover', '0') == '3' ? 'checked' : '' }}>
                                <label class="form-check-label text-primary text-start text-white" for="pergolaCover3">Üveg tetős</label>
                            </div>
                            @if ($errors->has('pergolaCover'))
                            <span class="text-danger error-message">{{ $errors->first('pergolaCover') }}</span>
                            @endif
                        </div>

                        <div class="col-12 mb-5 text-start" id="policarbonatID">
                            <label class="form-label text-primary text-start w-100 text-white">Polikarbonát tipusa</label><br>
                            <input type="radio" name="policarbonatType" value="0" hidden {{ old('policarbonatType', '0') == '0' ? 'checked' : '' }}>

                            <div class="form-check form-check-inline">
                                <input class="" type="radio" name="policarbonatType" id="policarbonatType1" value="1" {{ old('policarbonatType', '0' ) == '1' ? 'checked' : '' }}>
                                <label class="form-check-label text-primary text-start text-white" for="policarbonatType1">Opál</label>
                            </div>

                            <div class="form-check form-check-inline">
                                <input class="" type="radio" name="policarbonatType" id="policarbonatType2" value="2" {{ old('policarbonatType', '0' ) == '2' ? 'checked' : '' }}>
                                <label class="form-check-label text-primary text-start text-white" for="policarbonatType2">Víztiszta</label>
                            </div>
                            @if ($errors->has('policarbonatType'))
                            <span class="text-danger error-message">{{ $errors->first('policarbonatType') }}</span>
                            @endif
                        </div>

                        <div class="col-12 mb-5 text-start" id="glassID">
                            <label class="form-label text-primary text-start w-100 text-white">Üveg tipusa</label><br>
                            <input type="radio" name="glassType" value="0" hidden {{ old('glassType', '0') == '0' ? 'checked' : '' }}>

                            <div class="form-check form-check-inline">
                                <input class="" type="radio" name="glassType" id="glassType1" value="1" {{ old('glassType', '0') == '1' ? 'checked' : '' }}>
                                <label class="form-check-label text-primary text-start text-white" for="glassType1">Víztiszta</label>
                            </div>

                            <div class="form-check form-check-inline">
                                <input class="" type="radio" name="glassType" id="glassType2" value="2" {{ old('glassType', '0') == '2' ? 'checked' : '' }}>
                                <label class="form-check-label text-primary text-start text-white" for="glassType2">Opál</label>
                            </div>

                            <div class="form-check form-check-inline">
                                <input class="" type="radio" name="glassType" id="glassType3" value="3" {{ old('glassType', '0') == '3' ? 'checked' : '' }}>
                                <label class="form-check-label text-primary text-start text-white" for="glassType3">Sötétített</label>
                            </div>
                            @if ($errors->has('glassType'))
                            <span class="text-danger error-message">{{ $errors->first('glassType') }}</span>
                            @endif
                        </div>

                        <div class="col-12 mb-5">
                            <label class="form-label text-primary text-start w-100 text-white" for="sizeWidth">Méret</label>
                            <div class="row mb-3">
                                <div class="col-12 col-md-4 mb-3 mb-md-0">
                                    <input class="form-control" id="sizeOverHang" name="sizeOverHang" type="number" placeholder="Kinyúlás(mm)" min="1" value="{{ old('sizeOverHang') }}" />
                                    @if ($errors->has('sizeOverHang'))
                                    <span class="text-danger error-message">{{ $errors->first('sizeOverHang') }}</span>
                                    @endif
                                </div>
                                <div class="col-12 col-md-4 mb-3 mb-md-0">
                                    <input class="form-control" id="sizeLenght" name="sizeLenght" type="number" placeholder="Hosszúság(mm)" min="1" value="{{ old('sizeLenght') }}" />

                                    @if ($errors->has('sizeLenght'))
                                    <span class="text-danger error-message">{{ $errors->first('sizeLenght') }}</span>
                                    @endif
                                </div>
                                <div class="col-12 col-md-4">
                                    <input class="form-control" id="sizeHeight" name="sizeHeight" type="number" placeholder="Magasság(mm)" min="1" value="{{ old('sizeHeight') }}" />

                                    @if ($errors->has('sizeHeight'))
                                    <span class="text-danger error-message">{{ $errors->first('sizeHeight') }}</span>
                                    @endif
                                </div>
                            </div>
                        </div>

                        <div class="col-12 mb-5 text-start" id="colorBioklimatikusID">
                            <label class="form-label text-primary text-start w-100 text-white">Színválasztás</label><br>
                            <label class="form-label text-primary text-start mx-3 w-100 text-white">Lamella színe</label><br>
                            <input type="radio" name="colorBioklimatikusLamella" value="0" hidden {{ old('colorBioklimatikusLamella', '0') == '0' ? 'checked' : '' }}>

                            <div class="form-check form-check-inline">
                                <input class="" type="radio" name="colorBioklimatikusLamella" id="colorBioklimatikusLamella1" value="1" {{ old('colorBioklimatikusLamella', '0') == '1' ? 'checked' : '' }}>
                                <label class="form-check-label text-primary text-start text-white" for="colorBioklimatikusLamella1">Fehér</label>
                            </div>

                            <div class="form-check form-check-inline">
                                <input class="" type="radio" name="colorBioklimatikusLamella" id="colorBioklimatikusLamella2" value="2" {{ old('colorBioklimatikusLamella', '0') == '2' ? 'checked' : '' }}>
                                <label class="form-check-label text-primary text-start text-white" for="colorBioklimatikusLamella2">Barna</label>
                            </div>

                            <div class="form-check form-check-inline">
                                <input class="" type="radio" name="colorBioklimatikusLamella" id="colorBioklimatikusLamella3" value="3" {{ old('colorBioklimatikusLamella', '0') == '3' ? 'checked' : '' }}>
                                <label class="form-check-label text-primary text-start text-white" for="colorBioklimatikusLamella3">Antracit</label>
                            </div>

                            <div class="form-check form-check-inline">
                                <input class="" type="radio" name="colorBioklimatikusLamella" id="colorBioklimatikusLamella4" value="4" {{ old('colorBioklimatikusLamella', '0') == '4' ? 'checked' : '' }}>
                                <label class="form-check-label text-primary text-start text-white" for="colorBioklimatikusLamella4">Fekete</label>
                            </div>

                            <div class="form-check form-check-inline">
                                <input class="" type="radio" name="colorBioklimatikusLamella" id="colorBioklimatikusLamella5" value="5" {{ old('colorBioklimatikusLamella', '0') == '5' ? 'checked' : '' }}>
                                <label class="form-check-label text-primary text-start text-white" for="colorBioklimatikusLamella5">Alumínium szürke</label>
                            </div>

                            <div class="form-check form-check-inline">
                                <input class="" type="radio" name="colorBioklimatikusLamella" id="colorBioklimatikusLamella6" value="6" {{ old('colorBioklimatikusLamella', '0') == '6' ? 'checked' : '' }}>
                                <label class="form-check-label text-primary text-start text-white" for="colorBioklimatikusLamella6">Más szín</label>
                            </div>

                            <div class="form-check form-check-inline" id="colorBioklimatikusLamellaID">
                                <input class="form-control w-50" id="color" name="colorBioklimatikusLamellaText" type="text" placeholder="" value="{{ old('colorBioklimatikusLamellaText') }}" />
                                @if ($errors->has('colorBioklimatikusLamellaText'))
                                <span class="text-danger error-message">{{ $errors->first('colorBioklimatikusLamellaText') }}</span>
                                @endif
                            </div>

                            @if ($errors->has('colorBioklimatikusLamella'))
                            <span class="text-danger error-message">{{ $errors->first('colorBioklimatikusLamella') }}</span>
                            @endif

                            <label class="form-label text-primary text-start mx-3 w-100 text-white">Szerkezet színe</label><br>
                            <input type="radio" name="colorBioklimatikusStructure" value="0" hidden {{ old('colorBioklimatikusStructure', '0') == '0' ? 'checked' : '' }}>

                            <div class="form-check form-check-inline">
                                <input class="" type="radio" name="colorBioklimatikusStructure" id="colorBioklimatikusStructure1" value="1" {{ old('colorBioklimatikusStructure', '0') == '1' ? 'checked' : '' }}>
                                <label class="form-check-label text-primary text-start text-white" for="colorBioklimatikusStructure1">Fehér</label>
                            </div>

                            <div class="form-check form-check-inline">
                                <input class="" type="radio" name="colorBioklimatikusStructure" id="colorBioklimatikusStructure2" value="2" {{ old('colorBioklimatikusStructure', '0') == '2' ? 'checked' : '' }}>
                                <label class="form-check-label text-primary text-start text-white" for="colorBioklimatikusStructure2">Barna</label>
                            </div>

                            <div class="form-check form-check-inline">
                                <input class="" type="radio" name="colorBioklimatikusStructure" id="colorBioklimatikusStructure3" value="3" {{ old('colorBioklimatikusStructure', '0') == '3' ? 'checked' : '' }}>
                                <label class="form-check-label text-primary text-start text-white" for="colorBioklimatikusStructure3">Antracit</label>
                            </div>

                            <div class="form-check form-check-inline">
                                <input class="" type="radio" name="colorBioklimatikusStructure" id="colorBioklimatikusStructure4" value="4" {{ old('colorBioklimatikusStructure', '0') == '4' ? 'checked' : '' }}>
                                <label class="form-check-label text-primary text-start text-white" for="colorBioklimatikusStructure4">Fekete</label>
                            </div>

                            <div class="form-check form-check-inline">
                                <input class="" type="radio" name="colorBioklimatikusStructure" id="colorBioklimatikusStructure5" value="5" {{ old('colorBioklimatikusStructure', '0') == '5' ? 'checked' : '' }}>
                                <label class="form-check-label text-primary text-start text-white" for="colorBioklimatikusStructure5">Alumínium szürke</label>
                            </div>

                            <div class="form-check form-check-inline">
                                <input class="" type="radio" name="colorBioklimatikusStructure" id="colorBioklimatikusStructure6" value="6" {{ old('colorBioklimatikusStructure', '0') == '6' ? 'checked' : '' }}>
                                <label class="form-check-label text-primary text-start text-white" for="colorBioklimatikusStructure6">Más szín</label>
                            </div>

                            <div class="form-check form-check-inline" id="colorBioklimatikusStructureID">
                                <input class="form-control w-50" id="color" name="colorBioklimatikusStructureText" type="text" placeholder="" value="{{ old('colorBioklimatikusStructureText') }}" />
                                @if ($errors->has('colorBioklimatikusStructureText'))
                                <span class="text-danger error-message">{{ $errors->first('colorBioklimatikusStructureText') }}</span>
                                @endif
                            </div>

                            @if ($errors->has('colorBioklimatikusStructure'))
                            <span class="text-danger error-message">{{ $errors->first('colorBioklimatikusStructure') }}</span>
                            @endif
                        </div>

                        <div class="col-12 mb-5 text-start" id="colorPolicarbonatID">
                            <label class="form-label text-primary text-start w-100 text-white">Színválasztás</label><br>
                            <label class="form-label text-primary text-start mx-3 w-100 text-white">Szerkezet színe</label><br>
                            <input type="radio" name="colorPolicarbonatStructure" value="0" hidden {{ old('colorPolicarbonatStructure', '0') == '0' ? 'checked' : '' }}>

                            <div class="form-check form-check-inline">
                                <input class="" type="radio" name="colorPolicarbonatStructure" id="colorPolicarbonatStructure1" value="1" {{ old('colorPolicarbonatStructure', '0') == '1' ? 'checked' : '' }}>
                                <label class="form-check-label text-primary text-start text-white" for="colorPolicarbonatStructure1">Fehér</label>
                            </div>

                            <div class="form-check form-check-inline">
                                <input class="" type="radio" name="colorPolicarbonatStructure" id="colorPolicarbonatStructure2" value="2" {{ old('colorPolicarbonatStructure', '0') == '2' ? 'checked' : '' }}>
                                <label class="form-check-label text-primary text-start text-white" for="colorPolicarbonatStructure2">Antracit</label>
                            </div>

                            <div class="form-check form-check-inline">
                                <input class="" type="radio" name="colorPolicarbonatStructure" id="colorPolicarbonatStructure3" value="3" {{ old('colorPolicarbonatStructure', '0') == '3' ? 'checked' : '' }}>
                                <label class="form-check-label text-primary text-start text-white" for="colorPolicarbonatStructure3">Fekete</label>
                            </div>

                            <div class="form-check form-check-inline">
                                <input class="" type="radio" name="colorPolicarbonatStructure" id="colorPolicarbonatStructure4" value="4" {{ old('colorPolicarbonatStructure', '0') == '4' ? 'checked' : '' }}>
                                <label class="form-check-label text-primary text-start text-white" for="colorPolicarbonatStructure4">Alumínium szürke</label>
                            </div>

                            <div class="form-check form-check-inline">
                                <input class="" type="radio" name="colorPolicarbonatStructure" id="colorPolicarbonatStructure5" value="5" {{ old('colorPolicarbonatStructure', '0') == '5' ? 'checked' : '' }}>
                                <label class="form-check-label text-primary text-start text-white" for="colorPolicarbonatStructure5">Más szín</label>
                            </div>

                            <div class="form-check form-check-inline" id="colorPolicarbonatStructureID">
                                <input class="form-control w-50" id="color" name="colorPolicarbonatStructureText" type="text" placeholder="" value="{{ old('colorPolicarbonatStructureText') }}" />
                                @if ($errors->has('colorPolicarbonatStructureText'))
                                <span class="text-danger error-message">{{ $errors->first('colorPolicarbonatStructureText') }}</span>
                                @endif
                            </div>
                            @if ($errors->has('colorPolicarbonatStructure'))
                            <span class="text-danger error-message">{{ $errors->first('colorPolicarbonatStructure') }}</span>
                            @endif
                        </div>

                        <div class="col-12 mb-5 text-start" id="colorGlassID">
                            <label class="form-label text-primary text-start w-100 text-white">Színválasztás</label><br>
                            <label class="form-label text-primary text-start mx-3 w-100 text-white">Szerkezet színe</label><br>
                            <input type="radio" name="colorGlassStructure" value="0" hidden {{ old('colorGlassStructure', '0') == '0' ? 'checked' : '' }}>

                            <div class="form-check form-check-inline">
                                <input class="" type="radio" name="colorGlassStructure" id="colorGlassStructure1" value="1" {{ old('colorGlassStructure', '0') == '1' ? 'checked' : '' }}>
                                <label class="form-check-label text-primary text-start text-white" for="colorGlassStructure1">Antracit</label>
                            </div>

                            <div class="form-check form-check-inline">
                                <input class="" type="radio" name="colorGlassStructure" id="colorGlassStructure2" value="2" {{ old('colorGlassStructure', '0') == '2' ? 'checked' : '' }}>
                                <label class="form-check-label text-primary text-start text-white" for="colorGlassStructure2">Fekete</label>
                            </div>
                            @if ($errors->has('colorGlassStructure'))
                            <span class="text-danger error-message">{{ $errors->first('colorGlassStructure') }}</span>
                            @endif
                        </div>

                        <div class="col-12 mb-5 text-start" id="extraBioklimatikusID">
                            <input class="text-start mx-2" id="extraBioklimatikusZIP" name="extraBioklimatikusZIP" type="checkbox" value="1" {{ old('extraBioklimatikusZIP') ? 'checked' : '' }}>
                            <label class="form-label text-primary text-start text-white" for="extraBioklimatikusZIP">Zip Screen</label> <br>

                            <div class="row mb-3" id="extraBioklimatikusZIPID">
                                <div class="col-12 col-md-6 mb-3 mb-md-0">
                                    <input class="form-control" id="extraBioklimatikusZIPShort" name="extraBioklimatikusZIPShort" type="number" placeholder="Hány rövid oldal?" min="0" value="{{ old('extraBioklimatikusZIPShort') }}" />
                                    @if ($errors->has('extraBioklimatikusZIPShort'))
                                    <span class="text-danger error-message">{{ $errors->first('extraBioklimatikusZIPShort') }}</span>
                                    @endif
                                </div>
                                <div class="col-12 col-md-6">
                                    <input class="form-control" id="extraBioklimatikusZIPLong" name="extraBioklimatikusZIPLong" type="number" placeholder="Hány hosszú oldal?" min="0" value="{{ old('extraBioklimatikusZIPLong') }}" />
                                    @if ($errors->has('extraBioklimatikusZIPLong'))
                                    <span class="text-danger error-message">{{ $errors->first('extraBioklimatikusZIPLong') }}</span>
                                    @endif
                                </div>
                            </div>

                            <input class="text-start mx-2" id="extraBioklimatikusSlidingGlass" name="extraBioklimatikusSlidingGlass" type="checkbox" value="1" {{ old('extraBioklimatikusSlidingGlass') ? 'checked' : '' }}>
                            <label class="form-label text-primary text-start text-white" for="extraBioklimatikusSlidingGlass">Tolóüveg</label> <br>

                            <div class="row mb-3" id="extraBioklimatikusSlidingGlassID">
                                <div class="col-12 col-md-6 mb-3 mb-md-0">
                                    <input class="form-control" id="extraBioklimatikusSlidingGlassShort" name="extraBioklimatikusSlidingGlassShort" type="number" placeholder="Hány rövid oldal?" min="0" value="{{ old('extraBioklimatikusSlidingGlassShort') }}" />
                                    @if ($errors->has('extraBioklimatikusSlidingGlassShort'))
                                    <span class="text-danger error-message">{{ $errors->first('extraBioklimatikusSlidingGlassShort') }}</span>
                                    @endif
                                </div>
                                <div class="col-12 col-md-6">
                                    <input class="form-control" id="extraBioklimatikusSlidingGlassLong" name="extraBioklimatikusSlidingGlassLong" type="number" placeholder="Hány hosszú oldal?" min="0" value="{{ old('extraBioklimatikusSlidingGlassLong') }}" />
                                    @if ($errors->has('extraBioklimatikusSlidingGlassLong'))
                                    <span class="text-danger error-message">{{ $errors->first('extraBioklimatikusSlidingGlassLong') }}</span>
                                    @endif
                                </div>
                            </div>
                            <div class="row mb-3" id="extraBioklimatikusSlidingGlass1ID">
                                <div class="col mx-5">
                                    <input class="text-start mx-2" id="extraBioklimatikusSlidingLock" name="extraBioklimatikusSlidingLock" type="checkbox" value="1" {{ old('extraBioklimatikusSlidingLock') ? 'checked' : '' }}>
                                    <label class="form-label text-primary text-start text-white" for="extraBioklimatikusSlidingLock">Zár kell hozzá</label> <br>
                                    @if ($errors->has('extraBioklimatikusSlidingLock'))
                                    <span class="text-danger error-message">{{ $errors->first('extraBioklimatikusSlidingLock') }}</span>
                                    @endif
                                </div>
                            </div>

                            <input class="text-start mx-2" id="extraBioklimatikusZsaluzia" name="extraBioklimatikusZsaluzia" type="checkbox" value="1" {{ old('extraBioklimatikusZsaluzia') ? 'checked' : '' }}>
                            <label class="form-label text-primary text-start text-white" for="extraBioklimatikusZsaluzia">Zsalúzia oldalfal</label> <br>

                            <div class="row mb-3" id="extraBioklimatikusZsaluziaID">
                                <div class="col-12 col-md-6 mb-3 mb-md-0">
                                    <input class="form-control" id="extraBioklimatikusZsaluziaShort" name="extraBioklimatikusZsaluziaShort" type="number" placeholder="Hány rövid oldal?" min="0" value="{{ old('extraBioklimatikusZsaluziaShort') }}" />
                                    @if ($errors->has('extraBioklimatikusZsaluziaShort'))
                                    <span class="text-danger error-message">{{ $errors->first('extraBioklimatikusZsaluziaShort') }}</span>
                                    @endif
                                </div>
                                <div class="col-12 col-md-6">
                                    <input class="form-control" id="extraBioklimatikusZsaluziaLong" name="extraBioklimatikusZsaluziaLong" type="number" placeholder="Hány hosszú oldal?" min="0" value="{{ old('extraBioklimatikusZsaluziaLong') }}" />
                                    @if ($errors->has('extraBioklimatikusZsaluziaLong'))
                                    <span class="text-danger error-message">{{ $errors->first('extraBioklimatikusZsaluziaLong') }}</span>
                                    @endif
                                </div>
                            </div>

                            <input class="text-start mx-2" id="extraBioklimatikusRainSensor" name="extraBioklimatikusRainSensor" type="checkbox" value="1" {{ old('extraBioklimatikusRainSensor') ? 'checked' : '' }}>
                            <label class="form-label text-primary text-start text-white" for="extraBioklimatikusRainSensor">Esőérzékelő</label><br>

                            <input class="text-start mx-2" id="extraBioklimatikusWindSensor" name="extraBioklimatikusWindSensor" type="checkbox" value="1" {{ old('extraBioklimatikusWindSensor') ? 'checked' : '' }}>
                            <label class="form-label text-primary text-start text-white" for="extraBioklimatikusWindSensor">Szélérzékelő</label><br>

                            <input class="text-start mx-2" id="extraBioklimatikusLEDOptions" name="extraBioklimatikusLEDOptions" type="checkbox" value="1" {{ old('extraBioklimatikusLEDOptions') ? 'checked' : '' }}>
                            <label class="form-label text-primary text-start text-white" for="extraBioklimatikusLEDOptions">LED opciók</label><br>

                            <div class="col-12 text-start" id="extraBioklimatikusLEDID">
                                <input type="radio" name="extraBioklimatikusLED" value="0" hidden {{ old('extraBioklimatikusLED', '0') == '0' ? 'checked' : '' }}>
                                <div class="form-check form-check-inline">
                                    <input class="" type="radio" name="extraBioklimatikusLED" id="extraBioklimatikusLED1" value="1" {{ old('extraBioklimatikusLED', '0') == '1' ? 'checked' : '' }}>
                                    <label class="form-check-label text-primary text-start text-white" for="extraBioklimatikusLED1">Meleg fehér</label>
                                </div>

                                <div class="form-check form-check-inline">
                                    <input class="" type="radio" name="extraBioklimatikusLED" id="extraBioklimatikusLED2" value="2" {{ old('extraBioklimatikusLED', '0') == '2' ? 'checked' : '' }}>
                                    <label class="form-check-label text-primary text-start text-white" for="extraBioklimatikusLED2">Hideg fehér</label>
                                </div>

                                <div class="form-check form-check-inline">
                                    <input class="" type="radio" name="extraBioklimatikusLED" id="extraBioklimatikusLED2" value="3" {{ old('extraBioklimatikusLED', '0') == '3' ? 'checked' : '' }}>
                                    <label class="form-check-label text-primary text-start text-white" for="extraBioklimatikusLED2">RGB</label>
                                </div>
                                @if ($errors->has('extraBioklimatikusLED'))
                                <span class="text-danger error-message">{{ $errors->first('extraBioklimatikusLED') }}</span>
                                @endif
                            </div>
                        </div>

                        <div class="col-12 mb-5 text-start" id="extraPoliGlassID">
                            <input class="text-start mx-2" id="extraPoliGlassZIP" name="extraPoliGlassZIP" type="checkbox" value="1" {{ old('extraPoliGlassZIP') ? 'checked' : '' }}>
                            <label class="form-label text-primary text-start text-white" for="extraPoliGlassZIP">Zip Screen</label> <br>

                            <div class="row mb-3" id="extraPoliGlassZIPID">
                                <div class="col-12 col-md-6 mb-3 mb-md-0">
                                    <input class="form-control" id="extraPoliGlassZIPShort" name="extraPoliGlassZIPShort" type="number" placeholder="Hány rövid oldal?" min="0" value="{{ old('extraPoliGlassZIPShort') }}" />
                                    @if ($errors->has('extraPoliGlassZIPShort'))
                                    <span class="text-danger error-message">{{ $errors->first('extraPoliGlassZIPShort') }}</span>
                                    @endif
                                </div>
                                <div class="col-12 col-md-6">
                                    <input class="form-control" id="extraPoliGlassZIPLong" name="extraPoliGlassZIPLong" type="number" placeholder="Hány hosszú oldal?" min="0" value="{{ old('extraPoliGlassZIPLong') }}" />
                                    @if ($errors->has('extraPoliGlassZIPLong'))
                                    <span class="text-danger error-message">{{ $errors->first('extraPoliGlassZIPLong') }}</span>
                                    @endif
                                </div>
                            </div>

                            <input class="text-start mx-2" id="extraPoliGlassSlidingGlass" name="extraPoliGlassSlidingGlass" type="checkbox" value="1" {{ old('extraPoliGlassSlidingGlass') ? 'checked' : '' }}>
                            <label class="form-label text-primary text-start text-white" for="extraPoliGlassSlidingGlass">Tolóüveg</label> <br>

                            <div class="row mb-3" id="extraPoliGlassSlidingGlassID">
                                <div class="col-12 col-md-6 mb-3 mb-md-0">
                                    <input class="form-control" id="extraPoliGlassSlidingGlassShort" name="extraPoliGlassSlidingGlassShort" type="number" placeholder="Hány rövid oldal?" min="0" value="{{ old('extraPoliGlassSlidingGlassShort') }}" />
                                    @if ($errors->has('extraPoliGlassSlidingGlassShort'))
                                    <span class="text-danger error-message">{{ $errors->first('extraPoliGlassSlidingGlassShort') }}</span>
                                    @endif
                                </div>
                                <div class="col-12 col-md-6">
                                    <input class="form-control" id="extraPoliGlassSlidingGlassLong" name="extraPoliGlassSlidingGlassLong" type="number" placeholder="Hány hosszú oldal?" min="0" value="{{ old('extraPoliGlassSlidingGlassLong') }}" />
                                    @if ($errors->has('extraPoliGlassSlidingGlassLong'))
                                    <span class="text-danger error-message">{{ $errors->first('extraPoliGlassSlidingGlassLong') }}</span>
                                    @endif
                                </div>
                            </div>
                            <div class="row mb-3" id="extraPoliGlassSlidingGlass1ID">
                                <div class="col mx-5">
                                    <input class="text-start mx-2" id="extraPoliGlassSlidingLock" name="extraPoliGlassSlidingLock" type="checkbox" value="1" {{ old('extraPoliGlassSlidingLock') ? 'checked' : '' }}>
                                    <label class="form-label text-primary text-start text-white" for="extraPoliGlassSlidingLock">Zár kell hozzá</label> <br>
                                    @if ($errors->has('extraPoliGlassSlidingLock'))
                                    <span class="text-danger error-message">{{ $errors->first('extraPoliGlassSlidingLock') }}</span>
                                    @endif
                                </div>
                            </div>

                            <input class="text-start mx-2" id="extraPoliGlassLEDSpot" name="extraPoliGlassLEDSpot" type="checkbox" value="1" {{ old('extraPoliGlassLEDSpot') ? 'checked' : '' }}>
                            <label class="form-label text-primary text-start text-white" for="extraPoliGlassLEDSpot">LED SPOT</label><br>

                        </div>

                        <div class="col-12 mb-5 text-start">
                            <input class="text-start mx-2" id="installation" name="installation" type="checkbox" value="1" {{ old('installation') ? 'checked' : '' }}>
                            <label class="form-label text-primary text-start text-white" for="installation">Beszereléssel szeretné?</label>
                            <div class="row mb-3" id="installationID">
                                <div class="col mx-5">
                                    <input class="form-control" id="installationPlace" name="installationPlace" type="text" placeholder="Hol lenne a beszerelés?" value="{{ old('installationPlace') }}" />
                                    @if ($errors->has('installationPlace'))
                                    <span class="text-danger error-message">{{ $errors->first('installationPlace') }}</span>
                                    @endif
                                </div>
                            </div>
                        </div>
                        <div class="col-12 mb-5">
                            <input class="form-control" id="name" name="name" type="text" placeholder="Név" value="{{ old('name') }}" />
                            @if ($errors->has('name'))
                            <span class="text-danger error-message">{{ $errors->first('name') }}</span>
                            @endif
                        </div>
                        <div class="col-12 mb-5">
                            <input class="form-control" id="emailAddress" name="email" type="email" placeholder="E-mail" value="{{ old('email') }}" />
                            @if ($errors->has('email'))
                            <span class="text-danger error-message">{{ $errors->first('email') }}</span>
                            @endif
                        </div>
                        <div class="col-12 mb-5">
                            <input class="form-control" id="phone" name="phone" type="text" placeholder="Telefonszám" value="{{ old('phone') }}" />
                            @if ($errors->has('phone'))
                            <span class="text-danger error-message">{{ $errors->first('phone') }}</span>
                            @endif
                        </div>
                        <div class="col-12">
                            <button class="btn btn-primary" id="submitButton" type="submit">Küldés</button>
                        </div>
                    </div>
                    <div class="invalid-feedback mt-2" data-sb-feedback="email:required">An email is required.</div>
                    <div class="invalid-feedback mt-2" data-sb-feedback="email:email">Email is not valid.</div>
                    <!-- Submit success message-->
                    @if(session()->has('success'))
                    <div id="successMessage" class="alert alert-success mt-5">
                        {{ session()->get('success') }}
                    </div>
                    @endif
                    @if(session()->has('error'))
                    <div id="errorMessage" class="alert alert-danger mt-5">
                        {{ session()->get('error') }}
                    </div>
                    @endif
                </form>
            </div>
        </div>
    </div>
    <script>
        const coverRadios = document.querySelectorAll('input[name="pergolaCover"]');
        const policarbonatWrapper = document.getElementById('policarbonatID');
        const glassWrapper = document.getElementById('glassID');
        const colorBioklimatikusWrapper = document.getElementById('colorBioklimatikusID');
        const colorPolicarbonatWrapper = document.getElementById('colorPolicarbonatID');
        const colorGlassWrapper = document.getElementById('colorGlassID');
        const extraBioklimatikusWrapper = document.getElementById('extraBioklimatikusID');
        const extraPoliGlassWrapper = document.getElementById('extraPoliGlassID');

        coverRadios.forEach(radio => {
            radio.addEventListener('change', function() {
                colorBioklimatikusWrapper.style.display = this.value === '1' ? 'block' : 'none';
                extraBioklimatikusWrapper.style.display = this.value === '1' ? 'block' : 'none';
                policarbonatWrapper.style.display = this.value === '2' ? 'block' : 'none';
                colorPolicarbonatWrapper.style.display = this.value === '2' ? 'block' : 'none';
                glassWrapper.style.display = this.value === '3' ? 'block' : 'none';
                colorGlassWrapper.style.display = this.value === '3' ? 'block' : 'none';
                extraPoliGlassWrapper.style.display = (this.value === '2' || this.value === '3') ? 'block' : 'none';
            });
        });

        colorBioklimatikusWrapper.style.display = coverRadios[1].checked ? 'block' : 'none';
        extraBioklimatikusWrapper.style.display = coverRadios[1].checked ? 'block' : 'none';
        policarbonatWrapper.style.display = coverRadios[2].checked ? 'block' : 'none';
        colorPolicarbonatWrapper.style.display = coverRadios[2].checked ? 'block' : 'none';
        glassWrapper.style.display = coverRadios[3].checked ? 'block' : 'none';
        colorGlassWrapper.style.display = coverRadios[3].checked ? 'block' : 'none';
        extraPoliGlassWrapper.style.display = (coverRadios[2].checked || coverRadios[3].checked) ? 'block' : 'none';

        const colorBioklimatikusLamellaRadios = document.querySelectorAll('input[name="colorBioklimatikusLamella"]');
        const colorBioklimatikusLamellaWrapper = document.getElementById('colorBioklimatikusLamellaID');

        colorBioklimatikusLamellaRadios.forEach(radio => {
            radio.addEventListener('change', function() {
                colorBioklimatikusLamellaWrapper.style.display = this.value === '6' ? 'flex' : 'none';
            });
        });

        colorBioklimatikusLamellaWrapper.style.display = colorBioklimatikusLamellaRadios[6].checked ? 'flex' : 'none';

        const colorBioklimatikusStructureRadios = document.querySelectorAll('input[name="colorBioklimatikusStructure"]');
        const colorBioklimatikusStructureWrapper = document.getElementById('colorBioklimatikusStructureID');

        colorBioklimatikusStructureRadios.forEach(radio => {
            radio.addEventListener('change', function() {
                colorBioklimatikusStructureWrapper.style.display = this.value === '6' ? 'flex' : 'none';
            });
        });

        colorBioklimatikusStructureWrapper.style.display = colorBioklimatikusStructureRadios[6].checked ? 'flex' : 'none';

        const colorPolicarbonatStructureRadios = document.querySelectorAll('input[name="colorPolicarbonatStructure"]');
        const colorPolicarbonatStructureWrapper = document.getElementById('colorPolicarbonatStructureID');

        colorPolicarbonatStructureRadios.forEach(radio => {
            radio.addEventListener('change', function() {
                colorPolicarbonatStructureWrapper.style.display = this.value === '5' ? 'flex' : 'none';
            });
        });

        colorPolicarbonatStructureWrapper.style.display = colorPolicarbonatStructureRadios[5].checked ? 'flex' : 'none';

        const extraBioklimatikusZIPCheckbox = document.getElementById('extraBioklimatikusZIP');
        const extraBioklimatikusZIPWrapper = document.getElementById('extraBioklimatikusZIPID');
        extraBioklimatikusZIPWrapper.style.display = extraBioklimatikusZIPCheckbox.checked ? 'flex' : 'none';

        extraBioklimatikusZIPCheckbox.addEventListener('change', function() {
            extraBioklimatikusZIPWrapper.style.display = this.checked ? 'flex' : 'none';
        });

        const extraBioklimatikusZsaluziaCheckbox = document.getElementById('extraBioklimatikusZsaluzia');
        const extraBioklimatikusZsaluziaWrapper = document.getElementById('extraBioklimatikusZsaluziaID');
        extraBioklimatikusZsaluziaWrapper.style.display = extraBioklimatikusZsaluziaCheckbox.checked ? 'flex' : 'none';

        extraBioklimatikusZsaluziaCheckbox.addEventListener('change', function() {
            extraBioklimatikusZsaluziaWrapper.style.display = this.checked ? 'flex' : 'none';
        });

        const extraBioklimatikusSlidingGlassCheckbox = document.getElementById('extraBioklimatikusSlidingGlass');
        const extraBioklimatikusSlidingGlassWrapper = document.getElementById('extraBioklimatikusSlidingGlassID');
        const extraBioklimatikusSlidingGlass1Wrapper = document.getElementById('extraBioklimatikusSlidingGlass1ID');
        extraBioklimatikusSlidingGlassWrapper.style.display = extraBioklimatikusSlidingGlassCheckbox.checked ? 'flex' : 'none';
        extraBioklimatikusSlidingGlass1Wrapper.style.display = extraBioklimatikusSlidingGlassCheckbox.checked ? 'flex' : 'none';

        extraBioklimatikusSlidingGlassCheckbox.addEventListener('change', function() {
            extraBioklimatikusSlidingGlassWrapper.style.display = this.checked ? 'flex' : 'none';
            extraBioklimatikusSlidingGlass1Wrapper.style.display = this.checked ? 'flex' : 'none';
        });

        const extraBioklimatikusLEDOptionsCheckbox = document.getElementById('extraBioklimatikusLEDOptions');
        const extraBioklimatikusLEDOptionsWrapper = document.getElementById('extraBioklimatikusLEDID');
        extraBioklimatikusLEDOptionsWrapper.style.display = extraBioklimatikusLEDOptionsCheckbox.checked ? 'flex' : 'none';

        extraBioklimatikusLEDOptionsCheckbox.addEventListener('change', function() {
            extraBioklimatikusLEDOptionsWrapper.style.display = this.checked ? 'flex' : 'none';
        });


        const extraPoliGlassZIPCheckbox = document.getElementById('extraPoliGlassZIP');
        const extraPoliGlassZIPWrapper = document.getElementById('extraPoliGlassZIPID');
        extraPoliGlassZIPWrapper.style.display = extraPoliGlassZIPCheckbox.checked ? 'flex' : 'none';

        extraPoliGlassZIPCheckbox.addEventListener('change', function() {
            extraPoliGlassZIPWrapper.style.display = this.checked ? 'flex' : 'none';
        });

        const extraPoliGlassSlidingGlassCheckbox = document.getElementById('extraPoliGlassSlidingGlass');
        const extraPoliGlassSlidingGlassWrapper = document.getElementById('extraPoliGlassSlidingGlassID');
        const extraPoliGlassSlidingGlass1Wrapper = document.getElementById('extraPoliGlassSlidingGlass1ID');
        extraPoliGlassSlidingGlassWrapper.style.display = extraPoliGlassSlidingGlassCheckbox.checked ? 'flex' : 'none';
        extraPoliGlassSlidingGlass1Wrapper.style.display = extraPoliGlassSlidingGlassCheckbox.checked ? 'flex' : 'none';

        extraPoliGlassSlidingGlassCheckbox.addEventListener('change', function() {
            extraPoliGlassSlidingGlassWrapper.style.display = this.checked ? 'flex' : 'none';
            extraPoliGlassSlidingGlass1Wrapper.style.display = this.checked ? 'flex' : 'none';
        });

        const installationCheckbox = document.getElementById('installation');
        const installationWrapper = document.getElementById('installationID');
        installationWrapper.style.display = installationCheckbox.checked ? 'flex' : 'none';

        installationCheckbox.addEventListener('change', function() {
            installationWrapper.style.display = this.checked ? 'flex' : 'none';
        });
    </script>
</section>

<!-- Contact -->
<section class="contact-section bg-black">
    <div class="container px-4 px-lg-5">
        <div class="row gx-4 gx-lg-5">
            {{-- <div class="col-md-4 mb-3 mb-md-0">
                        <div class="card py-4 h-100">
                            <div class="card-body text-center">
                                <i class="fas fa-map-marked-alt text-primary mb-2" style="color: #e01f26 !important;"></i>
                                <h4 class="text-uppercase m-0">Address</h4>
                                <hr class="my-4 mx-auto" />
                                <div class="small text-black-50">4923 Market Street, Orlando FL</div>
                            </div>
                        </div>
                    </div> --}}
            <div class="col-md-6 mb-3 mb-md-0">
                <div class="card py-4 h-100">
                    <div class="card-body text-center">
                        <i class="fas fa-envelope text-primary mb-2" style="color: #e01f26 !important;"></i>
                        <h4 class="text-uppercase m-0">Email</h4>
                        <hr class="my-4 mx-auto" />
                        <div class="small text-black-50"><a href="mail-to:info@domakaputech.hu">info@domakaputech.hu</a></div>
                    </div>
                </div>
            </div>
            <div class="col-md-6 mb-3 mb-md-0">
                <div class="card py-4 h-100">
                    <div class="card-body text-center">
                        <i class="fas fa-mobile-alt text-primary mb-2" style="color: #e01f26 !important;"></i>
                        <h4 class="text-uppercase m-0">Telefonszám</h4>
                        <hr class="my-4 mx-auto" />
                        <div class="small text-black-50"><a href="tel:+36 (70) 310-0036">+36 (70) 310-0036</a></div>
                        <div class="small text-black-50"><a href="tel:+36 (70) 904-0921">+36 (70) 904-0921</a></div>
                    </div>
                </div>
            </div>
        </div>
        {{-- <div class="social d-flex justify-content-center">
                    {{-- <a class="mx-2" href="#!"><i class="fab fa-twitter"></i></a> - -}}
        <a class="mx-2" href="#!"><i class="fab fa-facebook-f"></i></a>
        {{-- <a class="mx-2" href="#!"><i class="fab fa-github"></i></a> - -}}
    </div> --}}
    </div>
</section>

@endsection